/* vim: set sw=8 ts=8 si et: */
/*********************************************
* Timer for timeout supervision of the stk 500 protocol
* Author: Guido Socher, Copyright: GPL 
* Copyright: GPL
**********************************************/

#include <avr/signal.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/io.h>
#include <avr/wdt.h>
#include "avr_compat.h"

void delay_ms(unsigned int ms)
/* delay for a minimum of <ms> */
/* with a 4Mhz clock, the resolution is 1 ms */
{
        uint8_t inner,inner1;
        while (ms) {
                inner = 200;
                while (inner) {
                        inner--;
                        inner1 = 70;
                        while (inner1) {
                                inner1--;
                        }
                }
                ms--;
        }
}

void wd_init(void)
{
        // timeout the watchdog after 1 sec:
        wdt_enable(WDTO_1S);
}

void wd_kick(void)
{
        wdt_reset();
}


