/*********************************************
* vim: set sw=8 ts=8 si :
* Author: Guido Socher, Copyright: GPL 
* This program is to test the led connected to
* PD5. 
* Chip type           : ATMEGA8
* Clock frequency     : Internal clock 1 Mhz (factory default)
*********************************************/
#include <avr/io.h>
#include <inttypes.h>
#define F_CPU 1000000UL  // 1 MHz
#include <avr/delay.h>


void delay_ms(unsigned int ms)
/* delay for a minimum of <ms> */
{
	// we use a calibrated macro. This is more
	// accurate and not so much compiler dependent
	// as self made code.
	while(ms){
		_delay_ms(0.96);
		ms--;
	}
}

int main(void)
{
          /* enable PD5 as output */
          DDRD|= (1<<DDD5);

          /* PD5 is 5 (see file include/avr/iom8.h) and 1<<PD5 is 00100000 
	   * This can also be written as _BV(PD5)*/
          while (1) {
                      /* led on, pin=0 */
                      PORTD &= ~(1<<PD5);
                      delay_ms(500);
                      /* set output to 5V, LED off */
                      PORTD|= (1<<PD5);
                      delay_ms(500);
          }
	  return(0);
}

